﻿var users = {
    context: $(".v-users"),
    datatable: null,
    treeview: null,
    selectedGroup: null,
    isSysAdminGroup: false,
    initializeDataTable: function (groupId) {
        var conditionsCallbacks = {
            hasSurveys: function (row) {
                return row["HasSurveys"];
            },
            canView: function (row) {
                return row["CanView"];
            },
            canModify: function (row) {
                return row["CanModify"];
            },
            canDelete: function (row) {
                return !row["IsSystemUser"] && row["CanDelete"];
            },
            canActivate: function (row) {
                return row["CanModify"] && !row["IsSystemUser"] && !row["Active"];
            },
            canDeactivate: function (row) {
                return row["CanModify"] && !row["IsSystemUser"] && row["Active"];
            },
            canAssignToGroup: function (row) {
                return !users.isSysAdminGroup && row["CanModify"] && (!users.selectedGroup || users.selectedGroup.Id == 0)
            },
            canRemoveFromGroup: function (row) {
                return !users.isSysAdminGroup && ((!row["IsSystemUser"] || (users.selectedGroup && !users.selectedGroup.IsSystemGroup)) && users.selectedGroup && users.selectedGroup.Id > 0) && row["CanModify"];
            },
            canSelectRow: function (row) {
                return (row["CanModify"] || row["CanDelete"]) && !row["IsSystemUser"] || !users.selectedGroup || !users.selectedGroup.IsSystemGroup;
            }
        };

        var contextMenuItems = [
            { "Action": "surveys", "Label": resources.MobileOfflineSurveys, "DisplayCondition": conditionsCallbacks.hasSurveys },
            { "Divider": true, "DisplayCondition": conditionsCallbacks.hasSurveys },
            { "Action": "activate", "Label": resources.Activate, "DisplayCondition": conditionsCallbacks.canActivate },
            { "Action": "deactivate", "Label": resources.Deactivate, "DisplayCondition": conditionsCallbacks.canDeactivate },
            { "Divider": true, "DisplayCondition": conditionsCallbacks.canModify },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": conditionsCallbacks.canDelete },
            { "Action": "properties", "Label": resources.Properties, "DisplayCondition": conditionsCallbacks.canView },
        ];

        var toolBarItems = [
            { "Action": "activate", "Label": resources.Activate, "DisplayCondition": conditionsCallbacks.canActivate },
            { "Action": "deactivate", "Label": resources.Deactivate, "DisplayCondition": conditionsCallbacks.canDeactivate },
            { "Action": "add", "Label": resources.AssignToGroup, "DisplayCondition": conditionsCallbacks.canAssignToGroup },
            { "Action": "remove", "Label": resources.RemoveFromGroup, "DisplayCondition": conditionsCallbacks.canRemoveFromGroup },
            { "Action": "delete", "Label": resources.Delete, "DisplayCondition": conditionsCallbacks.canDelete },
        ];

        var columns = [{ "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id", "Type": "numeric", "Key": true },
                    { "Name": "UserName", "Title": resources.UserName, "Data": "UserName", "Class": "v-name", "HideInSelector": true },
                    { "Name": "Active", "Title": resources.Active, "Data": "Active", "Type": "boolean", "ShowIcon": true }];

        if (hasMarketSight) {
            columns.push({ "Name": "MarketSightActive", "Data": "MarketSightActive", "Title": resources.VoxcoAnalytics, "Type": "boolean", "ShowIcon": true });
        }

        columns.push({ "Name": "Email", "Title": resources.Email, "Data": "Email" },
                    { "Name": "Firstname", "Title": resources.FirstName, "Data": "Firstname" },
                    { "Name": "Lastname", "Title": resources.LastName, "Data": "Lastname" },                
                    { "Name": "Language", "Title": resources.Language, "Data": "Language" },
                    { "Name": "TimeZoneName", "Title": resources.TimeZone, "Data": "TimeZoneName", "Searchable": false },
                    { "Name": "LastLoginTime", "Title": resources.LastLogin, "Data": "LastLoginTime", "Searchable": false, "Type": "date" });

        this.datatable = $(".v-usersTable").a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAction("GetUsers", "Users", "Settings"),
            ajaxParams: { "groupId": groupId },
            allowRowSelection: conditionsCallbacks.canSelectRow,
            stateKey: "Users",
            columns: columns,
            defaultSorting: "UserName",
            toolBarItems: toolBarItems,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "add":
                        users.addUsersToGroups(ids);
                        break;
                    case "remove":
                        users.removeUsersFromGroup(ids);
                        break;
                    case "activate":
                        users.activateUsers(ids);
                        break;
                    case "deactivate":
                        users.deactivateUsers(ids);
                        break;
                    case "delete":
                        users.deleteUsers(ids);
                        break;
                }
            },
            contextMenuItems: contextMenuItems,
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "surveys":
                        modalDialog.showWindow(a4.getAction("Surveys", "Users", "Settings", { userId: row.Id }), 500);
                        break;
                    case "activate":
                        users.activateUsers([row.Id]);
                        break;
                    case "deactivate":
                        users.deactivateUsers([row.Id]);
                        break;
                    case "delete":
                        users.deleteUsers([row.Id]);
                        break;
                    case "properties":
                        users.editUser(row);
                        break;
                }
            },
            loadData: function (event, data) {
                for (var i = 0; i < data.result.data.length; i++) {
                    if (!data.result.data[i].CanView) {
                        data.result.data.splice(i, 1);
                    }
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.Active, "AjaxParams": { "active": true } },
                    { "Label": resources.Inactive, "AjaxParams": { "active": false } }
                ]
            },
            localizableTexts: { "All": resources.AllUsers, "Search": resources.SearchUsers }
        });
    },
    initializeTreeView: function () {
        var conditionsCallbacks = {
            canEditPermissions: function (row) {
                return !row["IsSystemGroup"] && row["Id"] > 0 && canModifyPermissions && a4.hasAcuity4;
            },
            canEditUsers: function (row) {
                return row["Id"] > 0 && row["CanModify"];
            },
            canCopy: function (row) {
                return !row["IsSystemGroup"] && row["Id"] > 0 && canCreateGroups;
            },
            canViewProperties: function (row) {
                return !row["IsSystemGroup"] && row["Id"] > 0 && row["CanView"];
            },
            canDelete: function (row) {
                return row["Id"] > 0 && row["UsersCount"] == 0 && row["CanDelete"];
            }
        };

        var actionButtons = [
            { Action: "editPermissions", Label: resources.EditPermissions, Icon: "lock", DisplayCondition: conditionsCallbacks.canEditPermissions },
            { Action: "editUsers", Label: resources.AssignUsers, Icon: "group", DisplayCondition: conditionsCallbacks.canEditUsers },
            { Action: "copy", Label: resources.Copy, Icon: "copy", DisplayCondition: conditionsCallbacks.canCopy },
            { Action: "properties", Label: resources.Properties, Icon: "edit", DisplayCondition: conditionsCallbacks.canViewProperties },
            { Action: "delete", Label: resources.Delete, Icon: "remove", DisplayCondition: conditionsCallbacks.canDelete }
        ];

        var customItems = [];

        if (canViewAllUsers)
            customItems.push({ Action: "all", Name: resources.AllUsers }, { Action: "unassigned", Name: resources.UnassignedUsers });

        if (isSysAdmin)
            customItems.push({ Action: "sysadmins", Name: resources.SysAdmins });

        this.treeview = $(".h-userGroups", this.context).a4listview({
            ajaxAction: a4.getAction("GetUserGroups", "Users", "Settings"),
            highlightFirstNode: true,
            customItems: customItems,
            draw: function (event, data) {
                var group = data.selectedNode;
                var groupId = group ? group.Id : null;

                if (users.datatable) {
                    users.datatable.a4datatable("option", "ajaxParams", { "groupId": groupId });
                    users.datatable.a4datatable("refresh");
                }
                else {
                    users.initializeDataTable(groupId);
                }

                var canCreate = data.isCustom ? canCreateUsers : group.CanCreate;

                $(".h-newUserMenu", users.context).toggle(!!canCreate);
                $(".h-newUserMenu .h-addUser", users.context).toggle(!!canCreate);
            },
            icons: null,
            selectNode: function (event, data) {
                if (!data.selected)
                    return;

                var tableParams = {};

                if (data.isCustom) {
                    users.selectedGroup = null;
                    tableParams.groupId = null;
                    tableParams.unassigned = (data.node.Action == "unassigned");
                    tableParams.sysadmins = (data.node.Action == "sysadmins");
                }
                else {
                    users.selectedGroup = data.node;
                    tableParams.groupId = data.node ? data.node.Id : null;
                    tableParams.unassigned = null;
                    tableParams.sysadmins = false;
                }

                users.datatable.a4datatable("option", "ajaxParams", tableParams);
                users.datatable.a4datatable("refresh", true);

                users.isSysAdminGroup = (data.node.Action == "sysadmins");

                var canCreate = data.isCustom ? canCreateUsers : data.node.CanCreate;

                $(".h-newUserMenu", users.context).toggle(!!canCreate);
                $(".h-newUserMenu .h-addUser", users.context).toggle(!!canCreate);
            },
            actionButtons: actionButtons,
            actionButtonClick: function (event, data) {
                var action = data.action;
                var node = data.node;

                switch (action) {
                    case "editPermissions":
                        modalDialog.showWindow(a4.getAction("PermissionsEditor", "Users", "Settings", { groupId: node.Id, name: node.Name }), 920, 950, { afterClose: function () { users.refreshContent(); } });
                        break;
                    case "editUsers":
                        modalDialog.showWindow(a4.getAction("EditGroupUsers", "Users", "Settings", { groupId: node.Id }), 550, 800, { afterClose: function () { users.refreshContent(); } });
                        break;
                    case "editRoles":
                        modalDialog.showWindow(a4.getAction("EditGroupRoles", "Users", "Settings", { groupId: node.Id }), 550, 800, { afterClose: function () { users.refreshContent(); } });
                        break;
                    case "copy":
                        users.copyGroup(node);
                        break;
                    case "delete":
                        users.deleteGroup(node);
                        break;
                    case "properties":
                        modalDialog.showWindow(a4.getAction("GroupProperties", "Users", "Settings", { groupId: node.Id }), 400, 600, { afterClose: function () { users.refreshContent(); } });
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchUserGroups }
        });
    },
    bindEvents: function () {
        users.context.on("click", ".h-addUser", function () {
            if (users.isSysAdminGroup) {
                modalDialog.showWindow(a4.getAction("EditSysAdmin", "Users", "Settings", { userId: 0 }), 600, 800, { afterClose: function () { users.refreshDataTable(); } });
            }
            else {
                var selectedGroupId = users.selectedGroup ? users.selectedGroup.Id : 0;
                modalDialog.showWindow(a4.getAction("EditProfile", "Shared", "Home", { userId: 0, newUser: true, defaultGroupId: selectedGroupId }), 600, 800, {
                    afterClose: function () {
                        users.refreshDataTable();
                        users.refreshContent();
                    }
                });
            }
        });

        users.context.on("click", ".h-addGroup", function () {
            modalDialog.showWindow(a4.getAction("GroupProperties", "Users", "Settings"), 300, 600, { afterClose: function () { users.refreshContent(); } });
        });

        users.context.on("click", ".h-importUsers", function () {
            modalDialog.showWindow(a4.getAction("ImportUsers", "Users", "Settings", { groupIds: users.selectedGroup && !isNaN(parseInt(users.selectedGroup.Id, 10)) ? users.selectedGroup.Id : "" }), 450, 600, { afterClose: function () { users.refreshDataTable(); } });
        });

        users.context.on("click", ".h-authSettings", function () {
            modalDialog.showWindow(a4.getAction("AuthenticationSettings", "Users", "Settings"), 500, 870, { afterClose: function () { users.refreshDataTable(); } });
        });

        users.context.on("click", ".h-passwordPolicy", function () {
            modalDialog.showWindow(a4.getAction("PasswordPolicy", "Users", "Settings"), 520, 800, { afterClose: function () { users.refreshDataTable(); } });
        });
    },
    addUsersToGroups: function (userIds) {
        modalDialog.showWindow(a4.getAction("AddUsersToGroups", "Users", "Settings", { userIds: userIds.join(",") }), 400, 500, { afterClose: function () { users.refreshContent(); } });
    },
    removeUsersFromGroup: function (ids) {
        if (ids.length > 0 && users.selectedGroup) {
            modalDialog.showConfirmDialog(confirmRemoveUsersResources, function () {
                a4.callServerMethod(a4.getAction("RemoveUsersFromGroup", "Users", "Settings"), { groupId: users.selectedGroup.Id, userIds: ids },
                    function (result) {
                        users.refreshContent();
                    });
            }, 220, 500, false, { "count": ids.length, "group": users.selectedGroup.Name });
        }
    },
    deleteUsers: function (ids) {
        if (ids.length > 0) {
            var deleteFunctionName = users.isSysAdminGroup ? "DeleteSysAdmins" : "DeleteUsers";
            modalDialog.showConfirmDelete(confirmDeleteUsersResources, function () {
                a4.callServerMethod(a4.getAction(deleteFunctionName, "Users", "Settings"), { ids: ids },
                    function (result) {
                        users.refreshDataTable();
                        users.refreshContent();
                    });
            }, ids.length);
        }
    },
    activateUsers: function (ids) {
        if (ids.length > 0) {
            modalDialog.showConfirmDialog(confirmActivateUsersResources, function () {
                a4.callServerMethod(a4.getAction("ActivateUsers", "Users", "Settings"), { ids: ids },
                    function (result) {
                        users.refreshDataTable();
                    });
            }, null, null, false, { "count": ids.length });
        }
    },
    deactivateUsers: function (ids) {
        if (ids.length > 0) {
            modalDialog.showConfirmDialog(confirmDeactivateUsersResources, function () {
                a4.callServerMethod(a4.getAction("DeactivateUsers", "Users", "Settings"), { ids: ids },
                    function (result) {
                        users.refreshDataTable();
                    });
            }, null, null, false, { "count": ids.length });
        }
    },
    editUser: function (user) {
        if (users.isSysAdminGroup)
            modalDialog.showWindow(a4.getAction("EditSysAdmin", "Users", "Settings", { userId: user.Id }), 600, 800, { afterClose: function () { users.refreshDataTable(); } });
        else
            modalDialog.showWindow(a4.getAction("EditProfile", "Shared", "Home", { userId: user.Id }), 600, 800, { afterClose: function () { users.refreshDataTable(); } });
    },
    copyGroup: function (group) {
        a4.callServerMethod(a4.getAction("CopyGroup", "Users", "Settings"), { groupId: group.Id, name: group.Name },
        function (result) {
            users.refreshContent();
            a4.showSuccessMessage(resources.UserGroupCreated.replace("{0}", result.newName));
        });
    },
    deleteGroup: function (group) {
        modalDialog.showConfirmDialog(confirmDeleteGroupResources, function () {
            a4.callServerMethod(a4.getAction("DeleteGroup", "Users", "Settings"), { groupId: group.Id },
                function (result) {
                    users.refreshContent();
                });
        }, 250, 500, true, { "group": group.Name });
    },
    refreshDataTable: function () {
        users.datatable.a4datatable("refresh");
    },
    refreshContent: function () {
        users.treeview.a4listview("refresh");
    }
}

$(document).ready(function () {
    if (users.context.length > 0) {
        users.initializeTreeView();
        users.bindEvents();
    }
});